/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.core.flag;

import de.z0rdak.yawp.core.flag.FlagMessage;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.FlagType;
import de.z0rdak.yawp.core.flag.IFlag;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public abstract class AbstractFlag
implements IFlag {
    protected String name;
    protected FlagType type;
    protected FlagState state;
    protected boolean doesOverride;
    protected FlagMessage msg;

    public AbstractFlag(String name, FlagType type, boolean override) {
        this(name, type, override, FlagState.DENIED);
    }

    public AbstractFlag(String name, FlagType type, boolean override, FlagState state) {
        this.name = name;
        this.type = type;
        this.state = state;
        this.doesOverride = override;
        this.msg = FlagMessage.DEFAULT_FLAG_MSG;
    }

    public AbstractFlag(String name, FlagType type) {
        this(name, type, false, FlagState.DENIED);
    }

    public AbstractFlag(String name, FlagType type, boolean override, FlagState state, String msg) {
        this(name, type, override, state);
        this.msg = new FlagMessage(msg);
    }

    public AbstractFlag(class_2487 nbt) {
        this.deserializeNBT(nbt);
    }

    @Override
    public FlagType getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isActive() {
        return this.state == FlagState.ALLOWED || this.state == FlagState.DENIED;
    }

    @Override
    public FlagState getState() {
        return this.state;
    }

    @Override
    public void setState(FlagState state) {
        this.state = state;
    }

    @Override
    public boolean doesOverride() {
        return this.doesOverride;
    }

    @Override
    public void setOverride(boolean override) {
        this.doesOverride = override;
    }

    @Override
    public FlagMessage getFlagMsg() {
        return this.msg;
    }

    @Override
    public void setFlagMsg(FlagMessage msg) {
        this.msg = msg;
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 nbt = new class_2487();
        nbt.method_10582("flag_name", this.name);
        nbt.method_10582("state", this.state.name);
        nbt.method_10556("override", this.doesOverride);
        nbt.method_10582("flag_type", this.type.flagType);
        nbt.method_10566("flag_msg", (class_2520)this.msg.serializeNBT());
        return nbt;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        boolean active;
        this.name = nbt.method_10558("flag_name");
        this.state = nbt.method_10545("state") ? FlagState.from(nbt.method_10558("state")) : (nbt.method_10545("is_active") ? ((active = nbt.method_10577("is_active")) ? FlagState.DENIED : FlagState.DISABLED) : FlagState.DISABLED);
        this.doesOverride = nbt.method_10577("override");
        this.type = FlagType.of(nbt.method_10558("flag_type"));
        this.msg = new FlagMessage(nbt.method_10562("flag_msg"));
    }

    @Override
    public int compareTo(IFlag o) {
        int nameComparisonRes = this.name.compareTo(o.getName());
        int stateResult = this.state.compareTo(o.getState());
        return nameComparisonRes + stateResult;
    }
}

